Ext.data.JsonP.sol_common_ix_FunctionBase({"tagname":"class","name":"sol.common.ix.FunctionBase","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ix.FunctionBase.js","href":"lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase"}],"abstract":true,"eloix":true,"requires":["sol.Logger"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"objId","tagname":"cfg","owner":"sol.common.ix.FunctionBase","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"method-process","meta":{"abstract":true}},{"name":"RF_FunctionName","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"static-method-RF_FunctionName","meta":{"abstract":true,"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"static-method-onEnterNode","meta":{"abstract":true,"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"static-method-onExitNode","meta":{"abstract":true,"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.FunctionBase","short_doc":"Basic operations used by elo business solutions are modularized as ix function modules. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":["sol.common.ix.functions.ApplyDynKwl","sol.common.ix.functions.BackToPreviousUser","sol.common.ix.functions.Blackening","sol.common.ix.functions.ChangeColor","sol.common.ix.functions.ChangeRights","sol.common.ix.functions.ChangeRightsWrapper","sol.common.ix.functions.ChangeUser","sol.common.ix.functions.ChangeWfName","sol.common.ix.functions.CheckDynAdHocFlowEnd","sol.common.ix.functions.CheckDynAdHocFlowStart","sol.common.ix.functions.CheckFromService","sol.common.ix.functions.CheckMandatoryFields","sol.common.ix.functions.CheckSolutionEnabled","sol.common.ix.functions.CopyFolderContents","sol.common.ix.functions.CopySordData","sol.common.ix.functions.CreateFromTemplate","sol.common.ix.functions.CreateSord","sol.common.ix.functions.Decide","sol.common.ix.functions.Delete","sol.common.ix.functions.FeedComment","sol.common.ix.functions.FillSord","sol.common.ix.functions.GenerateIdentifier","sol.common.ix.functions.Inherit","sol.common.ix.functions.IsoDate","sol.common.ix.functions.Move","sol.common.ix.functions.Notify","sol.common.ix.functions.RemoveAcl","sol.common.ix.functions.RestoreAcl","sol.common.ix.functions.Set","sol.common.ix.functions.Status","sol.common.ix.functions.Subscription","sol.common.ix.functions.UserDispatcher","sol.common.ix.functions.UserNodeStart","sol.common.ix.functions.UserRolesToMap","sol.common.ix.functions.UserToIndex","sol.contact.ix.functions.GenerateFilingStruct","sol.contact.ix.functions.MoveContact"],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.FunctionBase</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.Logger' rel='sol.Logger' class='docClass'>sol.Logger</a></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/sol.common.ix.functions.ApplyDynKwl' rel='sol.common.ix.functions.ApplyDynKwl' class='docClass'>sol.common.ix.functions.ApplyDynKwl</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.BackToPreviousUser' rel='sol.common.ix.functions.BackToPreviousUser' class='docClass'>sol.common.ix.functions.BackToPreviousUser</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.Blackening' rel='sol.common.ix.functions.Blackening' class='docClass'>sol.common.ix.functions.Blackening</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.ChangeColor' rel='sol.common.ix.functions.ChangeColor' class='docClass'>sol.common.ix.functions.ChangeColor</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.ChangeRights' rel='sol.common.ix.functions.ChangeRights' class='docClass'>sol.common.ix.functions.ChangeRights</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper' rel='sol.common.ix.functions.ChangeRightsWrapper' class='docClass'>sol.common.ix.functions.ChangeRightsWrapper</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.ChangeUser' rel='sol.common.ix.functions.ChangeUser' class='docClass'>sol.common.ix.functions.ChangeUser</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.ChangeWfName' rel='sol.common.ix.functions.ChangeWfName' class='docClass'>sol.common.ix.functions.ChangeWfName</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.CheckDynAdHocFlowEnd' rel='sol.common.ix.functions.CheckDynAdHocFlowEnd' class='docClass'>sol.common.ix.functions.CheckDynAdHocFlowEnd</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.CheckDynAdHocFlowStart' rel='sol.common.ix.functions.CheckDynAdHocFlowStart' class='docClass'>sol.common.ix.functions.CheckDynAdHocFlowStart</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.CheckFromService' rel='sol.common.ix.functions.CheckFromService' class='docClass'>sol.common.ix.functions.CheckFromService</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.CheckMandatoryFields' rel='sol.common.ix.functions.CheckMandatoryFields' class='docClass'>sol.common.ix.functions.CheckMandatoryFields</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.CheckSolutionEnabled' rel='sol.common.ix.functions.CheckSolutionEnabled' class='docClass'>sol.common.ix.functions.CheckSolutionEnabled</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.CopyFolderContents' rel='sol.common.ix.functions.CopyFolderContents' class='docClass'>sol.common.ix.functions.CopyFolderContents</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.CopySordData' rel='sol.common.ix.functions.CopySordData' class='docClass'>sol.common.ix.functions.CopySordData</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.CreateFromTemplate' rel='sol.common.ix.functions.CreateFromTemplate' class='docClass'>sol.common.ix.functions.CreateFromTemplate</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.CreateSord' rel='sol.common.ix.functions.CreateSord' class='docClass'>sol.common.ix.functions.CreateSord</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.Decide' rel='sol.common.ix.functions.Decide' class='docClass'>sol.common.ix.functions.Decide</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.Delete' rel='sol.common.ix.functions.Delete' class='docClass'>sol.common.ix.functions.Delete</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.FeedComment' rel='sol.common.ix.functions.FeedComment' class='docClass'>sol.common.ix.functions.FeedComment</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.FillSord' rel='sol.common.ix.functions.FillSord' class='docClass'>sol.common.ix.functions.FillSord</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.GenerateIdentifier' rel='sol.common.ix.functions.GenerateIdentifier' class='docClass'>sol.common.ix.functions.GenerateIdentifier</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.Inherit' rel='sol.common.ix.functions.Inherit' class='docClass'>sol.common.ix.functions.Inherit</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.IsoDate' rel='sol.common.ix.functions.IsoDate' class='docClass'>sol.common.ix.functions.IsoDate</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.Move' rel='sol.common.ix.functions.Move' class='docClass'>sol.common.ix.functions.Move</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.Notify' rel='sol.common.ix.functions.Notify' class='docClass'>sol.common.ix.functions.Notify</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.RemoveAcl' rel='sol.common.ix.functions.RemoveAcl' class='docClass'>sol.common.ix.functions.RemoveAcl</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.RestoreAcl' rel='sol.common.ix.functions.RestoreAcl' class='docClass'>sol.common.ix.functions.RestoreAcl</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.Set' rel='sol.common.ix.functions.Set' class='docClass'>sol.common.ix.functions.Set</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.Status' rel='sol.common.ix.functions.Status' class='docClass'>sol.common.ix.functions.Status</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.Subscription' rel='sol.common.ix.functions.Subscription' class='docClass'>sol.common.ix.functions.Subscription</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.UserDispatcher' rel='sol.common.ix.functions.UserDispatcher' class='docClass'>sol.common.ix.functions.UserDispatcher</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.UserNodeStart' rel='sol.common.ix.functions.UserNodeStart' class='docClass'>sol.common.ix.functions.UserNodeStart</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.UserRolesToMap' rel='sol.common.ix.functions.UserRolesToMap' class='docClass'>sol.common.ix.functions.UserRolesToMap</a></div><div class='dependency'><a href='#!/api/sol.common.ix.functions.UserToIndex' rel='sol.common.ix.functions.UserToIndex' class='docClass'>sol.common.ix.functions.UserToIndex</a></div><div class='dependency'><a href='#!/api/sol.contact.ix.functions.GenerateFilingStruct' rel='sol.contact.ix.functions.GenerateFilingStruct' class='docClass'>sol.contact.ix.functions.GenerateFilingStruct</a></div><div class='dependency'><a href='#!/api/sol.contact.ix.functions.MoveContact' rel='sol.contact.ix.functions.MoveContact' class='docClass'>sol.contact.ix.functions.MoveContact</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase' target='_blank'>lib_sol.common.ix.FunctionBase.js</a></div></pre><div class='doc-contents'><p>Basic operations used by elo business solutions are modularized as ix function modules.</p>\n\n<p>Implementations should allow using functions in different ways:\n  - As a workflow node (onEnterNode, onExitNode)\n  - Executed as a registered function call.</p>\n\n<h1>Implementing a a function</h1>\n\n<p>A function must extend the class FunctionBase and should implement the functions onEnterNode, onExitNode and RF_custom_functions_MyFunction on js script scope level.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"custom.function.MyFunction\", {\n  extend: \"<a href=\"#!/api/sol.common.ix.FunctionBase\" rel=\"sol.common.ix.FunctionBase\" class=\"docClass\">sol.common.ix.FunctionBase</a>\",\n\n  requiredConfig: [\"objId\", \"myParam\"],\n\n  initialize: function (config) {\n    var me = this;\n    me.$super(\"<a href=\"#!/api/sol.common.ix.FunctionBase\" rel=\"sol.common.ix.FunctionBase\" class=\"docClass\">sol.common.ix.FunctionBase</a>\", \"initialize\", [config]);\n  },\n\n  process: function() {\n    // function logic goes here\n    var me = this;\n    me.myParam;\n  },\n});\n\nfunction onEnterNode(clInfo, userId, wFDiagram, nodeId) {\n  var params = sol.common.ix.WfUtils.parseAndCheckParams(wFDiagram, nodeId),\n      module;\n    params.objId = wFDiagram.objId;\n    module = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"custom.functions.MyFunction\", params);\n    module.process();\n}\n\nfunction onExitNode(clInfo, userId, wFDiagram, nodeId) {\n  // same than onEnterNode\n}\n\nfunction RF_custom_functions_MyFunction(iXSEContext, args) {\n  var params = <a href=\"#!/api/sol.common.ix.RfUtils-method-parseAndCheckParams\" rel=\"sol.common.ix.RfUtils-method-parseAndCheckParams\" class=\"docClass\">sol.common.ix.RfUtils.parseAndCheckParams</a>(iXSEContext, arguments.callee.name, args, \"objId\", \"myParam\"),\n      module;\n    module = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"RF_custom_solution_functions_MyFunction\", params);\n    module.process();\n}\n</code></pre>\n\n<h1>Executing function as Workflow Node</h1>\n\n<p>Functions can be used as Workflow scripts. In this case the objId is set based on the current workflow and must not\nbe passed to the function.</p>\n\n<p>Other configurations can be defined in the notes field of each workflow. It is recommended to use one workflow node\nfor each function.</p>\n\n<pre><code>{\n  myParam: \"Yeah!\"\n}\n</code></pre>\n\n<h1>Execute function as ix registered function</h1>\n\n<p>Functions can be exectud with the help of sol.common.ix.RfUtils.execute. In this case the Utils class handles the\nix Any-Object transformation.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_custom_functions_MyFunction', {\n  objId: \"4711\",\n  myParam: \"Yeah!\"\n});\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-objId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.FunctionBase'>sol.common.ix.FunctionBase</span><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.FunctionBase'>sol.common.ix.FunctionBase</span><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.FunctionBase'>sol.common.ix.FunctionBase</span><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.FunctionBase'>sol.common.ix.FunctionBase</span><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of function modules' process. ...</div><div class='long'><p>Implementation of function modules' process.\nThis function must be implemented by the child class and should contain the logic of the function module.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_FunctionName' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.FunctionBase'>sol.common.ix.FunctionBase</span><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-static-method-RF_FunctionName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-static-method-RF_FunctionName' class='name expandable'>RF_FunctionName</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='abstract' >abstract</span><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.FunctionBase'>sol.common.ix.FunctionBase</span><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='abstract' >abstract</span><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.FunctionBase'>sol.common.ix.FunctionBase</span><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='abstract' >abstract</span><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true,"abstract":true}});